unit PictureShow;

// =========================================================================
//    TPictureShow  ()  ..
// =========================================================================

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, ExtDlgs,
  Dialogs, ExtCtrls, ComCtrls,  StdCtrls, ToolWin,
  CheckLst,
  //  
  MainData, PictureTools, AboutMain;

type TPictureShow = class(TPictureTools)
private
    // ------------------
    //  
    fImage     : TImage;
    fCListBox  : TCheckListBox;
    fStatusBar : TStatusBar;
    //------------------------
    fTimer     : TTimer;       //   AutoPlay
    fShowDir   : string;       //   
    fPicCount  : integer;      //     fShowDir
    fCurrInd   : integer;      //   
    fAutoRun   : boolean;      //    
    fShowTemp  : integer;      //    
    //------------------------
    //       fCListBox
    function ScanPictInDir() : Cardinal;
    //------------------------
    //      fCListBox
    procedure ShowByClick(Sender : TObject);
    //------------------------
    //    ,    
    function FindFirstPictIndx() : boolean;
    //    ,    
    function FindLastPictIndx() : boolean;
    //    ,    
    function FindPrevPictIndx() : boolean;
    //    ,    
    function FindNextPictIndx() : boolean;
    //------------------------
    //     
    procedure ShowImagegReport(RqOK : boolean;
                               RqFileName : string);
    //     (  onTimer)
    procedure ShowByTimer(Sender : TObject);
    //     ()
    procedure ShowByNavigation(RqCmd : char);
public
    //------------------------
    //   (      )
    constructor Create(RqImage        : TImage;
                       RqCheckListBox : TCheckListBox;
                       RqStatusBar    : TStatusBar);
    //  
    procedure Free;
    //------------------------
    //    
    procedure ShowFirstPicture();     //   
    procedure ShowPrevPicture();      //   
    procedure ShowNextPicture();      //   
    procedure ShowLastPicture();      //   
    //------------------------
    procedure ShowPlay();             //    
    procedure ShowStop();             //    
    //------------------------
    //    
    function AllPictuteEnabled() : integer;
    //------------------------
    //   
    function ShowCurrentImage() : boolean;
    //      
    procedure LoadPictureShow();
    // ------------------------
    //     
    property ShowTemp : integer read fShowTemp write fShowTemp;
end;


implementation


// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
// 04.11.2016
//   (      )
constructor TPictureShow.Create(RqImage        : TImage;
                                RqCheckListBox : TCheckListBox;
                                RqStatusBar    : TStatusBar);
var Ind : integer;                                
begin
    inherited Create(RqImage);
    fImage     := RqImage;
    fImage.Anchors := [akLeft,akTop];
    fImage.Align   := alNone;
    // ----------------------------
    fCListBox  := RqCheckListBox;
    fCListBox.OnClick := ShowByClick;
    // ----------------------------
    fStatusBar := RqStatusBar;
    // ----------------------------
    fTimer    := TTimer.Create(nil);
    fTimer.OnTimer := ShowByTimer;
    fShowTemp := 1000;
    fTimer.Interval := fShowTemp;
    fAutoRun := False;
    // -----------------------------
    fShowDir  := '';
    fPicCount := 0;
    fCurrInd  := -1;
    AutoSize     := True;
    Proportional := True;
    // -----------------------------
    //  fStatusBar
    if fStatusBar.Panels.Count = 0
    then begin
       with fStatusBar do
       begin
          Panels.BeginUpdate;
          Ind := Panels.Count - 1;
          try
              Panels.Add;  Inc(Ind);
              Panels.Items[Ind].Text := '';
              Panels.Items[Ind].Width := 150;
              Panels.Add;  Inc(Ind);
              Panels.Items[Ind].Text := '';
              Panels.Items[Ind].Width := 150;
              Panels.Add;  Inc(Ind);
              Panels.Items[Ind].Text := '';
              Panels.Items[Ind].Width := 2000;
          finally
             Panels.EndUpdate;
          end;
       end; // of with RqStatusBar
    end;
end;
// -------------------------------------------------------------------------
// 04.11.2016
procedure TPictureShow.Free;
begin
    fCListBox.OnClick := nil;
    if Assigned(fTimer) then fTimer.Free;
    inherited Free;
end;
// =========================================================================
//       ()
// =========================================================================
// -------------------------------------------------------------------------
// 03.11.2016
//    ,    
function TPictureShow.FindFirstPictIndx() : boolean;
var Ind : integer;
begin
   Result   := False;
   fCurrInd := -1;
   if fCListBox.Count < 1 then Exit;
   for Ind := 0 to (fCListBox.Count - 1)
   do if (not fCListBox.Checked[Ind])
      then begin
         fCurrInd := Ind;
         Result   := True;
         Break;
      end;
end;
// -------------------------------------------------------------------------
// 03.11.2016
//    ,    
function TPictureShow.FindLastPictIndx() : boolean;
var Ind : integer;
begin
   Result   := False;
   fCurrInd := -1;
   if fCListBox.Count < 1 then Exit;
   for Ind := (fCListBox.Count - 1) downto 0
   do if (not fCListBox.Checked[Ind])
      then begin
         fCurrInd := Ind;
         Result   := True;
         Break;
      end;
end;
// -------------------------------------------------------------------------
// 03.11.2016
//    ,    
function TPictureShow.FindPrevPictIndx() : boolean;
var Count : integer;
begin
   //  
   Result   := False;
   Count := 0;
   while (not Result) and (Count < 2)
   do begin
       Dec(fCurrInd);
       if fCurrInd < 0
       then begin
          fCurrInd := fCListBox.Count - 1;
          Inc(Count);
       end;
       if (not fCListBox.Checked[fCurrInd])
       then begin
         Result := True;
         Break;
       end;
   end;
   if Count >= 2 then fCurrInd := -1;
end;
// -------------------------------------------------------------------------
// 03.11.2016
//    ,    
function TPictureShow.FindNextPictIndx() : boolean;
var Count : integer;
begin
   //  
   Result   := False;
   Count := 0;
   while (not Result) and (Count < 2)
   do begin
       Inc(fCurrInd);
       if fCurrInd > (fCListBox.Count - 1)
       then begin
          fCurrInd := 0;
          Inc(Count);
       end;
       if (not fCListBox.Checked[fCurrInd])
       then begin
         Result := True;
         Break;
       end;
   end;
   if Count >= 2 then fCurrInd := -1;
end;
// =========================================================================
//      
// =========================================================================
// -------------------------------------------------------------------------
// 03.11.2016
//    
// (    )
function TPictureShow.AllPictuteEnabled() : integer;
var wInd  : integer;
begin
   Result := 0;
   if fCListBox.Count < 1 then Exit;
   //    
   for wInd  := 0 to (fCListBox.Count - 1)
   do if fCListBox.Checked[wInd] then Inc(Result);
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     
procedure TPictureShow.ShowImagegReport(RqOK : boolean;
                                        RqFileName : string);
begin
  with fStatusBar
  do begin
     if RqOK
     then begin
       //   Panels[0]
       Panels[0].Text := ' Image Numb : '
                         + IntToStr(fCurrInd + 1);
       Panels[1].Text := ' Image Size : '
                         + IntToStr(BitMapWidth)
                         + ' x '
                         + IntToStr(BitMapHeight);
       Panels[2].Text := RqFileName;
     end
     else begin
       //    Panels[2]
       Panels[0].Text := '';
       Panels[1].Text := '    ';
       Panels[2].Text := ' ' + RqFileName;
     end; // if RqOK
  end;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//   
function TPictureShow.ShowCurrentImage() : boolean;
var wFileName : string;
begin
    Result := False;
    if (fCurrInd < 0) or (fCurrInd > (fCListBox.Count - 1)) then Exit;
    wFileName := fShowDir + '\' + fCListBox.Items.Strings[fCurrInd];
    if FileExists(wFileName)
    then begin
          fImage.Width  := fImage.Parent.Width  - 4;
          fImage.Height := fImage.Parent.Height - 4;
          ImageClear;
          if JpegToImage(wFileName)
          then begin
             ShowImagegReport(True, wFileName);
             Result := True;
          end;
    end
    else ShowImagegReport(False, wFileName);
end;
// -------------------------------------------------------------------------
// 04.11.2016
//      fCListBox
procedure TPictureShow.ShowByClick(Sender : TObject);
begin
    fTimer.Enabled := False;
    fCurrInd := fCListBox.ItemIndex;
    ShowCurrentImage();
    if fAutoRun
    then begin
       //    
       fTimer.Interval := fShowTemp;
       fTimer.Enabled  := True;
    end;
end;
// -------------------------------------------------------------------------
// 03.11.2016
//     ()
procedure TPictureShow.ShowByNavigation(RqCmd : char);
var FindOK    : boolean;
begin
   if (fCListBox.Count <= 0)
   then begin
      fCurrInd  := -1;
      Exit;
   end;
   //      
   case RqCmd of
     'F' : FindOK := FindFirstPictIndx();
     'P' : FindOK := FindPrevPictIndx();
     'N' : FindOK := FindNextPictIndx();
     'L' : FindOK := FindLastPictIndx();
    else FindOK := False;
   end;
   if FindOK
   then begin
      fTimer.Enabled := False;
      if ShowCurrentImage()
      then fCListBox.Selected[fCurrInd]:= True;
      if fAutoRun
      then begin
           //    
           fTimer.Interval := fShowTemp;
           fTimer.Enabled  := True;
      end;
    end;
end;
// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
// 04.11.2016
// (public)   
procedure TPictureShow.ShowFirstPicture();
begin
   ShowByNavigation('F');
end;
// -------------------------------------------------------------------------
// 04.11.2016
// (public)   
procedure TPictureShow.ShowPrevPicture();
begin
   ShowByNavigation('P');
end;
// -------------------------------------------------------------------------
// 04.11.2016
// (public)   
procedure TPictureShow.ShowNextPicture();
begin
   ShowByNavigation('N');
end;
// -------------------------------------------------------------------------
// 04.11.2016
// (public)   
procedure TPictureShow.ShowLastPicture();
begin
   ShowByNavigation('L');
end;
// -------------------------------------------------------------------------
// 03.11.2016
//     (  onTimer)
procedure TPictureShow.ShowByTimer(Sender : TObject);
begin
  ShowNextPicture();
end;

// -------------------------------------------------------------------------
// 03.11.2016
//    
procedure TPictureShow.ShowPlay();
begin
  fAutoRun := True;
  fTimer.Enabled  := True;
end;
// -------------------------------------------------------------------------
// 03.11.2016
//    
procedure TPictureShow.ShowStop();
begin
   fAutoRun := False;
   fTimer.Enabled := False;
end;
// =========================================================================
//         
// =========================================================================
// -------------------------------------------------------------------------
// 03.11.2016
//       fCListBox
function TPictureShow.ScanPictInDir() : Cardinal;
const fExt1 = '.JPG';
      fExt2 = '.JPEG';
const fFAttr = faArchive;
var
  wDir   : string;
  wSR    : TSearchRec;
  wExt   : string;
  wStr   : string;
begin
    Result := 0;
    fCListBox.Clear;
    //  
    if (fShowDir = '') or (not DirectoryExists(fShowDir)) then Exit;
    //  
    wDir   := fShowDir + '\*.*';
    if FindFirst(wDir, fFAttr, wSR) = 0 then
    begin
      repeat
        //   
        if not(( wSR.Attr and fFAttr) > 0) then Continue;
        if (wSR.Name = '') then Continue;
        //    fCListBox   
        wExt := UpperCase(ExtractFileExt(wSR.Name));
        if (wExt = fExt1) or (wExt = fExt2)
        then begin
             wStr := ExtractFileName(wSR.Name);
             Result := Result + 1;
             fCListBox.Items.Add(wStr);
        end;
      until FindNext(wSR) <> 0;
      FindClose(wSR);
    end;
end;
// -------------------------------------------------------------------------
// 03.11.2016
//     
procedure TPictureShow.LoadPictureShow();
var wDialog   : TOpenPictureDialog;
begin
    ShowStop();
    wDialog := TOpenPictureDialog.Create(nil);
    wDialog.Filter :=  'Image files (*.jpg)|*.JPG';
    if wDialog.Execute
    then begin
        fShowDir  := ExtractFileDir(wDialog.FileName);
        fPicCount := ScanPictInDir();
        if fPicCount > 0 then ShowPlay();
    end;
    wDialog.Free;
end;
// =========================================================================
//     TPictureShow
// =========================================================================

end.
